extends "res://scripts/stair_element.gd"


export  var checkpoint_path : NodePath

onready var block_anim = get_node("AnimationPlayer")
onready var checkpoint_anim : AnimationPlayer = get_node(checkpoint_path).get_node(
		"AnimationPlayer")

var _triggered : bool = false


func _ready() -> void:
	_restore_checkpoint()

func block_way():
	_triggered  = true
	yield(get_tree().create_timer(1.5),"timeout")
	checkpoint_anim.play("checkpoint")
	sounds.checkpoint_play()
	yield(get_tree().create_timer(1.5),"timeout")
	block_anim.play("block_way")
	if get_tree().get_current_scene().current_level.is_level_complete:
		return
	_set_checkpoint()



func is_triggered() -> bool:
	return _triggered


func _set_checkpoint() -> void:
	var checkpoint : Spatial = get_node(checkpoint_path)
	B4DFramework.set_game_data(
		{
			"checkpoint" : checkpoint.get_global_transform().origin
		})


func _restore_checkpoint():
	var game_data = B4DFramework.get_game_data()
	var self_checkpoint : Spatial = get_node(checkpoint_path)
	
	if game_data.keys().find("checkpoint") == -1:
		return
	
	if game_data.checkpoint == self_checkpoint.get_global_transform().origin:
		block_anim.play("block_way")
		checkpoint_anim.play("checkpoint")
